<?php $__env->startSection('content'); ?>
    <?php
        $contactContent = getContent('contact.content', true);
        $contactElements = getContent('contact.element', orderById: true);
        $socialElements = getContent('social_icon.element', orderById: true);
    ?>

    <div class="section bg--light">
        <div class="container">
            <div class="card custom--card">
                <div class="card-body">
                    <div class="row g-4 flex-wrap-reverse">
                        <div class="col-lg-5 order-md-2">
                            <div class="d-flex justify-content-center mb-5">
                                <img alt="<?php echo app('translator')->get('image'); ?>" class="img-fluid text-center"
                                    src="<?php echo e(frontendImage('contact', @$contactContent->data_values->image, '600x575')); ?>">
                            </div>
                            <?php $__currentLoopData = $contactElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="contact-info">
                                    <div class="contact-info__icon-border">
                                        <div class="contact-info__icon">
                                            <?php echo @$contact->data_values->icon ?>
                                        </div>
                                    </div>
                                    <div class="contact-info__content">
                                        <h5 class="mt-0 mb-2">
                                            <?php echo e(__(@$contact->data_values->heading)); ?>

                                        </h5>
                                        <p class="mb-0">
                                            <?php echo e(__(@$contact->data_values->details)); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <ul class="list list--row contact-social">
                                <li class="list--row__item">
                                    <p><?php echo app('translator')->get('Social:'); ?></p>
                                </li>
                                <?php $__currentLoopData = $socialElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list--row__item">
                                        <a class="icon--circle" href="<?php echo e(@$social->data_values->url); ?>" target="_blank">
                                            <?php echo @$social->data_values->icon ?>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>

                        </div>
                        <div class="col-lg-7 order-md-2">
                            <form class="verify-gcaptcha" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="col-12">
                                    <h4 class="mt-0">
                                        <?php echo e(__(@$contactContent->data_values->heading)); ?>

                                    </h4>
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                    <input <?php if($user): ?> readonly <?php endif; ?> class="form-control form--control" name="name" required
                                        type="text" value="<?php echo e(old('name', @$user->fullname)); ?>">
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Email'); ?></label>
                                    <input <?php if($user): ?> readonly <?php endif; ?> class="form-control form--control" name="email" required
                                        type="email" value="<?php echo e(old('email', @$user->email)); ?>">
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                    <input class="form-control form--control" name="subject" required type="text" value="<?php echo e(old('subject')); ?>">
                                </div>
                                <div class="form-group">
                                    <label class="form-label"><?php echo app('translator')->get('Message'); ?></label>
                                    <textarea class="form-control form--control-textarea" name="message" required rows="5"><?php echo e(old('message')); ?></textarea>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                <div class="form-group">
                                    <button class="btn btn--base h-45 w-100" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>
    <div class="map-view">
        <div class="container-fluid p-0">
            <div class="row g-0">
                <div class="col-12">
                    <iframe class="map-view__frame"
                        src="https://maps.google.com/maps?q=<?php echo e(@$contactContent->data_values->latitude); ?>,<?php echo e(@$contactContent->data_values->longitude); ?>&hl=es;z=14&amp;output=embed"></iframe>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/U.S/Arizona/GreatAmericanTitle/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>