<?php $__env->startSection('content'); ?>
    <section class="section bg--light">
        <div class="container">
            <div class="row gy-4">

                <div class="col-md-6">
                    <div class="card custom--card">
                        <div class="card-header bg--base d-flex flex-wrap align-items-center justify-content-between">
                            <h6 class="text-white">
                                <?php if($escrow->buyer_id == auth()->user()->id): ?>
                                    <?php echo app('translator')->get('Buying'); ?> <?php echo e(__($escrow->category->name)); ?>

                                <?php else: ?>
                                    <?php echo app('translator')->get('Selling'); ?> <?php echo e(__($escrow->category->name)); ?>

                                <?php endif; ?>
                            </h6>

                            <?php if($escrow->status != Status::ESCROW_NOT_ACCEPTED): ?>
                                <a href="<?php echo e(route('user.escrow.milestone.index', $escrow->id)); ?>" class="btn btn-sm btn--dark">
                                    <?php echo app('translator')->get('See Milestones'); ?> <i class="las la-arrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>

                        <div class="card-body p-0">
                            <div class="list-group list-group-flush">
                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Escrow Number'); ?></small>
                                    <span><?php echo e($escrow->escrow_number); ?></span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Title'); ?></small>
                                    <span><?php echo e($escrow->title); ?></span>
                                </div>

                                <div class="list-group-item">
                                    <?php if($escrow->buyer_id == auth()->id()): ?>
                                        <small class="text-muted"><?php echo app('translator')->get('Seller'); ?></small>
                                        <span><?php echo e(__(@$escrow->seller->username ?? $escrow->invitation_mail)); ?></span>
                                    <?php else: ?>
                                        <small class="text-muted"><?php echo app('translator')->get('Buyer'); ?></small>
                                        <?php echo e(__(@$escrow->buyer->username ?? $escrow->invitation_mail)); ?>

                                    <?php endif; ?>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Charge Payer'); ?></small>
                                    <?php if($escrow->charge_payer == Status::CHARGE_PAYER_SELLER): ?>
                                        <span class="badge badge--dark"><?php echo app('translator')->get('Seller'); ?></span>
                                    <?php elseif($escrow->charge_payer == Status::CHARGE_PAYER_BUYER): ?>
                                        <span class="badge badge--info"><?php echo app('translator')->get('Buyer'); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge--success"><?php echo app('translator')->get('50%-50%'); ?></span>
                                    <?php endif; ?>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Status'); ?></small>
                                    <?php echo $escrow->escrowStatus ?>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Amount'); ?></small>
                                    <span><?php echo e(showAmount($escrow->amount)); ?></span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Charge'); ?></small>
                                    <span><?php echo e(showAmount($escrow->charge)); ?></span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Created Milestone'); ?></small>
                                    <span>
                                        <?php echo e(showAmount($escrow->milestones->sum('amount'))); ?>


                                    </span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Milestone Funded'); ?></small>
                                    <span>
                                        <?php echo e(showAmount($escrow->milestones->where('payment_status', Status::MILESTONE_FUNDED)->sum('amount'))); ?>


                                    </span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Milestone Unfunded'); ?></small>
                                    <span>
                                        <?php echo e(showAmount($escrow->milestones->where('payment_status', Status::MILESTONE_UNFUNDED)->sum('amount'))); ?>


                                    </span>
                                </div>

                                <div class="list-group-item">
                                    <small class="text-muted"><?php echo app('translator')->get('Rest Amount'); ?></small>
                                    <span>
                                        <?php echo e(showAmount($escrow->restAmount())); ?>

                                    </span>
                                </div>

                                <?php if($escrow->status == Status::ESCROW_DISPUTED): ?>
                                    <div class="list-group-item">
                                        <small class="text-muted"><?php echo app('translator')->get('Disputed By'); ?></small>
                                        <span>
                                            <?php echo e($escrow->disputer->username); ?>

                                        </span>
                                    </div>

                                    <div class="list-group-item">
                                        <h6 class="m-0 text--danger"><?php echo app('translator')->get('Dispute Reason'); ?></h6>
                                        <p class="m-0"><?php echo e(__($escrow->dispute_note)); ?></p>
                                    </div>
                                <?php endif; ?>
                            </div>

                        </div>

                        <?php if($escrow->status == Status::ESCROW_ACCEPTED || $escrow->status == Status::ESCROW_NOT_ACCEPTED): ?>
                            <?php
                                $hasSellerAndBuyer = $escrow->seller_id && $escrow->buyer_id;
                            ?>

                            <div class="card-footer d-flex flex-wrap justify-content-center gap-2 bg-white">
                                <?php if($escrow->status == Status::ESCROW_NOT_ACCEPTED): ?>
                                    <button class="btn btn--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to cancel this escrow?'); ?>"
                                        data-action="<?php echo e(route('user.escrow.cancel', $escrow->id)); ?>"><i
                                            class="la la-times"></i><?php echo app('translator')->get('Cancel'); ?></button>

                                    <?php if($escrow->creator_id != auth()->id() && $hasSellerAndBuyer): ?>
                                        <button class="btn btn--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to accept this escrow?'); ?>"
                                            data-action="<?php echo e(route('user.escrow.accept', $escrow->id)); ?>"><i
                                                class="la la-check"></i><?php echo app('translator')->get('Accept'); ?></button>
                                    <?php endif; ?>
                                <?php else: ?>
                                    
                                    <?php if($hasSellerAndBuyer): ?>
                                        <button class="btn btn--danger text-white user-action"> <i class="las la-exclamation-triangle"></i>
                                            <?php echo app('translator')->get('Dispute Escrow'); ?></button>
                                    <?php endif; ?>
                                    
                                    <?php if($escrow->restAmount() <= 0 && $escrow->buyer_id == auth()->user()->id && $hasSellerAndBuyer): ?>
                                        <button class="btn btn--primary confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to dispatch this escrow?'); ?>"
                                            data-action="<?php echo e(route('user.escrow.dispatch', $escrow->id)); ?>"><i class="la la-money-check-alt"></i>
                                            <?php echo app('translator')->get('Dispatch Payment'); ?></button>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="card custom--card">
                        <div class="card-header bg--base d-flex flex-wrap align-items-center justify-content-between">
                            <h6 class="text-white"><?php echo app('translator')->get('Conversations'); ?></h6>
                            <button type="button" class="btn btn-sm btn--dark reloadButton"><i class="las la-redo-alt"></i></button>
                        </div>
                        <div class="card-body">
                            <div class="messaging msg_history">
                                <div class="inbox_msg">
                                    <ul class="list msg-list d-flex flex-column">
                                        <?php if($messages->count() > 0): ?>
                                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $classText = $message->sender_id == auth()->user()->id ? 'send' : 'receive';
                                                ?>
                                                <div class="msg-list__item">
                                                    <div class="msg-<?php echo e($classText); ?>">
                                                        <?php if($escrow->status == Status::ESCROW_DISPUTED && $message->sender_id != auth()->id()): ?>
                                                            <p class="mb-0">
                                                                <?php if($message->admin): ?>
                                                                    <span class="fw-bold text--danger">
                                                                        <?php echo app('translator')->get('SYSTEM'); ?>
                                                                    </span>
                                                                <?php else: ?>
                                                                    <?php echo e(@$message->sender->username); ?>

                                                                <?php endif; ?>
                                                            </p>
                                                        <?php endif; ?>
                                                        <div class="msg-<?php echo e($classText); ?>__content">
                                                            <p class="msg-<?php echo e($classText); ?>__text mb-0">
                                                                <?php echo e(__($message->message)); ?>

                                                            </p>
                                                        </div>
                                                        <ul
                                                            class="list msg-<?php echo e($classText); ?>__history <?php if($classText == 'send'): ?> justify-content-end <?php endif; ?>">
                                                            <div class="msg-receive__history-item">
                                                                <?php echo e($message->created_at->format('h:i A')); ?></div>
                                                            <div class="msg-receive__history-item"><?php echo e($message->created_at->diffForHumans()); ?></div>
                                                        </ul>
                                                    </div>
                                                    </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <div class="empty-message text-center">
                                                <div class="empty-message__icon">
                                                    <i class="la la-comment-slash"></i>
                                                </div>
                                                <div class="empty-message__heading">
                                                    <?php echo app('translator')->get('No conversation yet'); ?>
                                                </div>

                                            </div>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <?php if($escrow->status != Status::ESCROW_CANCELLED && $escrow->status != Status::ESCROW_COMPLETED): ?>
                        <div class="msg-option">
                            <form class="message-form">
                                <div class="msg-option__content rounded-pill">
                                    <div class="msg-option__group ">
                                        <input type="text" class="form-control msg-option__input" name="message" autocomplete="off"
                                            placeholder="<?php echo app('translator')->get('Send Message'); ?>">
                                        <button type="submit" class="btn bg--base msg-option__button reloadButton rounded-pill">
                                            <i class="lab la-telegram-plane"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <div class="modal fade " id="actionModal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Dispute Escrow'); ?></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('user.escrow.dispute', $escrow->id)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Dispute Reason'); ?></label>
                            <textarea class="form-control form--control-textarea" name="dispute_reason" rows="3" placeholder="<?php echo app('translator')->get('Enter the reason'); ?>" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--base h-45 w-100"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/chat.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .list-group-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(".msg_history").animate({
                scrollTop: $('.msg_history').prop("scrollHeight")
            }, 1);

            var actionModal = $('#actionModal');

            $('.user-action').on('click', function() {
                actionModal.modal('show');
            });

            $('.message-form').on("submit", function(e) {
                e.preventDefault();
                $(this).find('button[type=submit]');
                let message = $(this).find('[name=message]').val();

                var url = '<?php echo e(route('user.escrow.message.reply')); ?>';
                var data = {
                    _token: "<?php echo e(csrf_token()); ?>",
                    conversation_id: "<?php echo e($conversation->id); ?>",
                    message: $(this).find('[name=message]').val()
                }

                $.post(url, data, function(response) {
                    if (response['error']) {
                        $.each(response['error'], function(i, v) {
                            notify('error', v);
                        });
                        return true;
                    }

                    var html = `
                            <div class="msg-list__item">
                                <div class="msg-send">
                                    <div class="msg-send__content">
                                        <p class="msg-send__text mb-0">
                                            ${response['message']}
                                        </p>
                                    </div>
                                    <ul class="list msg-send__history  justify-content-end ">
                                        <div class="msg-receive__history-item">${response['created_time']}</div>
                                        <div class="msg-receive__history-item">${response['created_diff']}</div>
                                    </ul>
                                </div>
                            </li>
                    `;

                    $('.msg-list').append(html);
                    $(".msg_history").animate({
                        scrollTop: $('.msg_history').prop("scrollHeight")
                    }, 1);
                });
                $(this).find('[name=message]').val('')

            });

            $('.reloadButton').on("click", function() {
                var url = '<?php echo e(route('user.escrow.message.get')); ?>';
                var data = {
                    conversation_id: "<?php echo e($conversation->id); ?>"
                }
                $.get(url, data, function(response) {

                    if (response['error']) {
                        $.each(response['error'], function(i, v) {
                            notify('error', v);
                        });
                        return true;
                    }

                    $('.msg-list').html(response);
                    $(".msg_history").animate({
                        scrollTop: $('.msg_history').prop("scrollHeight")
                    }, 1);
                });
            });

        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/title/escrow/account/core/resources/views/templates/basic/user/escrow/details.blade.php ENDPATH**/ ?>