<?php $__env->startSection('content'); ?>
    <section class="section bg--light">
        <div class="container">
            <div class="row gy-4">
                <?php
                    $kycContent = getContent('kyc.content', true);
                ?>
                <div class="notice"></div>
                <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
                    <div class="col-12">
                        <div class="alert alert-danger mb-0">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="alert-heading text--danger m-0"><?php echo app('translator')->get('KYC Verification Required'); ?></h4>
                                <button class="btn btn-outline-secondary btn-sm" data-bs-toggle="modal" data-bs-target="#kycRejectionReason">
                                    <?php echo app('translator')->get('Show Reason'); ?>
                                </button>
                            </div>
                            <hr>
                            <p class="mb-0">
                                <?php echo e(__(@$kycContent->data_values->reject)); ?>

                                <a href="<?php echo e(route('user.kyc.form')); ?>">
                                    <?php echo app('translator')->get('Click Here to Re-submit Documents'); ?>
                                </a>
                            </p>
                        </div>
                    </div>
                <?php elseif(auth()->user()->kv == Status::KYC_UNVERIFIED): ?>
                    <div class="col-12">
                        <div class="alert alert-info mb-0">
                            <h4 class="alert-heading text--danger"><?php echo app('translator')->get('KYC Verification Required'); ?></h4>
                            <hr>
                            <p class="mb-0">
                                <?php echo e(__(@$kycContent->data_values->required)); ?>

                                <a href="<?php echo e(route('user.kyc.form')); ?>">
                                    <?php echo app('translator')->get('Click Here to Verify'); ?>
                                </a>
                            </p>
                        </div>
                    </div>
                <?php elseif(auth()->user()->kv == Status::KYC_PENDING): ?>
                    <div class="col-12">
                        <div class="alert alert-warning mb-0">
                            <h4 class="alert-heading text--warning"><?php echo app('translator')->get('KYC Verification Pending'); ?></h4>
                            <hr>
                            <p class="mb-0">
                                <?php echo e(__(@$kycContent->data_values->pending)); ?>

                                <a href="<?php echo e(route('user.kyc.data')); ?>"><?php echo app('translator')->get('See KYC Data'); ?></a>
                            </p>
                        </div>
                    </div>
                <?php endif; ?>


                <div class="col-lg-8 col-xl-9">


                    <div class="d-flex flex-wrap gap-4">

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e(showAmount($data['balance'])); ?> </h6>
                                <div class="dash-card__icon icon icon--circle icon--md"><i class="la la-wallet"></i></div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Balance'); ?></h5>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['pendingDeposit']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md"><i class="la la-pause-circle"></i></div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Pending Deposits'); ?></h5>
                                <a href="<?php echo e(route('user.deposit.history', 'pending')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['pendingWithdrawals']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md"><i class="fa fa-pause-circle"></i></div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Pending Withdrawals'); ?></h5>
                                <a href="<?php echo e(route('user.withdraw.history', 'pending')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['totalEscrow']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="la la-handshake"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Total Escrow'); ?></span></h5>
                                <a href="<?php echo e(route('user.escrow.index')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['notAccepted']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="fas fa-spinner"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Not Accepted'); ?></h5>
                                <a href="<?php echo e(route('user.escrow.index', 'notAccepted')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['accepted']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="las la-check-circle"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Running Escrow'); ?></h5>
                                <a href="<?php echo e(route('user.escrow.index', 'accepted')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['completed']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="la la-check-double"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Completed'); ?></h5>
                                <a href="<?php echo e(route('user.escrow.index', 'completed')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['disputed']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="la la-exclamation-triangle"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Disputed'); ?></h5>
                                <a href="<?php echo e(route('user.escrow.index', 'disputed')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>

                        <div class="dash-card">
                            <div class="dash-card__header">
                                <h6 class="dash-card__value"><?php echo e($data['cancelled']); ?></h6>
                                <div class="dash-card__icon icon icon--circle icon--md">
                                    <i class="la la-times-circle"></i>
                                </div>
                            </div>
                            <div class="dash-card__body">
                                <h5 class="dash-card__title"><?php echo app('translator')->get('Canceled'); ?></h5>
                                <a href="<?php echo e(route('user.escrow.index', 'canceled')); ?>"><?php echo app('translator')->get('View All'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-xl-3">
                    <div class="transaction--card">
                        <div class="body">
                            <h6 class="title"><?php echo app('translator')->get('Latest Transactions'); ?></h6>
                            <div class="list-group list-group-flush">
                                <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <li class="list-group-item">
                                        <?php if($trx->trx_type == '+'): ?>
                                            <span class="d-block fw-md text--success">+<?php echo e(showAmount($trx->amount)); ?></span>
                                        <?php else: ?>
                                            <span class="d-block fw-md text--danger">-<?php echo e(showAmount($trx->amount)); ?></span>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('user.transactions')); ?>?search=<?php echo e($trx->trx); ?>">
                                            <small>
                                                <?php echo e(__($trx->details)); ?>

                                            </small>
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <li class="list-group-item"><?php echo app('translator')->get('No transaction yet'); ?></li>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </div>

    </section>

    <?php if(auth()->user()->kv == Status::KYC_UNVERIFIED && auth()->user()->kyc_rejection_reason): ?>
        <div class="modal fade custom--modal" id="kycRejectionReason">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('KYC Document Rejection Reason'); ?></h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <p class="py-3"><?php echo e(auth()->user()->kyc_rejection_reason); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        a {
            color: #68a3f9;
            text-decoration: none;
        }

        .transaction--card {
            background-color: #fff;
            border-radius: 5px;
            border: 1px solid #f3f3f3;
            box-shadow: 0 0 5px 10px hsl(var(--black)/.01)
        }

        .transaction--card .title {
            padding: 1rem;
            border-bottom: 1px solid #f3f3f3;
        }

        .transaction--card .list-group-item {
            border-bottom: 1px solid hsl(var(--border)/.3);
        }

        .transaction--card .list-group-item:last-child {
            border-radius: 0 0 5px 5px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ulsitlqp/titleagency.it.com/title/escrow/account/core/resources/views/templates/basic/user/dashboard.blade.php ENDPATH**/ ?>